import java.lang.Thread;


public class Steuerung extends Thread {
    public int m_iComputer1;
    public int m_iComputer2;
    public int m_iChannel;
    public int m_iTimer1;
    public int m_iTimer2;
    public int m_iTimeStep;
    static int m_iMillisPerTimeStep=800;
    public Steuerung() {
        super();
        m_iTimeStep = 30;
        m_iComputer1 = 0;
        m_iComputer2 = 0;
        m_iChannel = 0;
        m_iTimer1=0;
        m_iTimer2=0;
        this.start();
    }
    public void run() {
        for (;;) {
            try {
                this.sleep(m_iTimeStep);
            }
            catch (InterruptedException e) {;};
            // Schedule Sender
            int iSpeed = Global.sender.getSpeed();
            if (iSpeed>0) {
                m_iComputer1-=m_iTimeStep;
                if (m_iComputer1<0) {
                    Global.sender.upperLayerSend();
                    m_iComputer1+=((100-iSpeed)*10+80);
                }
            }
            // Schedule Receiver
            iSpeed = Global.receiver.getSpeed();
            if (iSpeed>0) {
                m_iComputer2-=m_iTimeStep;
                if (m_iComputer2<0) {
                    Global.receiver.upperLayerReceive();
                    m_iComputer2+=((100-iSpeed)*10+80);
                }
            }
            // Schedule Channel
            iSpeed = Global.channel.getSpeed();
            if (iSpeed>0) {
                Global.historyPanel.m_Scrollbar.hide();
                m_iChannel-=m_iTimeStep;
                if (m_iChannel<0) {
                    Global.channel.nextStep();
                    m_iChannel+=((100-iSpeed)*10+80);
                }
                m_iTimer1-=m_iTimeStep;
                if (m_iTimer1<0) {
                    m_iTimer1+=(m_iMillisPerTimeStep);
                    Global.sender.m_Timer.newTimeStep();
                }
                m_iTimer2-=m_iTimeStep;
                if (m_iTimer2<0) {
                    m_iTimer2+=(m_iMillisPerTimeStep);
                    Global.receiver.m_Timer.newTimeStep();
                }
            }
            else {
                 Global.historyPanel.m_Scrollbar.show();
            }

        }
    }
}
